<?php
$config  = require __DIR__ . '/../../config/config.php';
$baseUrl = $config['app']['base_url'];

$current = $_GET['url'] ?? '';
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Admin Panel</title>

    <style>
        body {
            margin:0;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            background:#f3f4f6;
            color:#111827;
        }

        .admin-shell {
            display:flex;
            height:100vh;
            overflow:hidden;
        }

        /* SIDEBAR */
        .admin-sidebar {
            width:240px;
            background:#0f172a;
            color:#e5e7eb;
            padding:18px 16px;
            display:flex;
            flex-direction:column;
        }

        .admin-logo {
            font-weight:700;
            font-size:20px;
            margin-bottom:22px;
        }

        .admin-nav {
            flex:1;
        }

        .admin-nav-group {
            margin-bottom:22px;
        }

        .admin-nav-title {
            font-size:11px;
            text-transform:uppercase;
            letter-spacing:.08em;
            color:#6b7280;
            margin:6px 0 6px;
        }

        .admin-nav a {
            display:block;
            padding:8px 10px;
            margin-bottom:4px;
            border-radius:8px;
            color:#e5e7eb;
            text-decoration:none;
            font-size:14px;
        }

        .admin-nav a:hover {
            background:#1f2937;
        }

        .admin-nav a.active {
            background:#1e293b;
            font-weight:600;
        }

        /* MAIN AREA */
        .admin-main {
            flex:1;
            padding:20px 26px 40px;
            overflow-y:auto;
        }

        .admin-topbar {
            text-align:right;
            font-size:13px;
            color:#6b7280;
            margin-bottom:10px;
        }

        .admin-topbar a {
            color:#6b7280;
            text-decoration:none;
        }
    </style>
</head>
<body>

<div class="admin-shell">
    <aside class="admin-sidebar">
        <div class="admin-logo">⚙ Admin Panel</div>

        <nav class="admin-nav">

            <div class="admin-nav-group">
                <div class="admin-nav-title">Übersicht</div>
                <a href="<?= $baseUrl ?>/index.php?url=admin/dashboard"
                   class="<?= str_starts_with($current, 'admin/dashboard') ? 'active' : '' ?>">
                    📊 Dashboard
                </a>

                <a href="<?= $baseUrl ?>/index.php?url=admin/users"
                   class="<?= str_starts_with($current, 'admin/users') ? 'active' : '' ?>">
                    👥 Benutzer
                </a>
            </div>

            <div class="admin-nav-group">
                <div class="admin-nav-title">Marktplatz</div>
                <a href="<?= $baseUrl ?>/index.php?url=admin/categories"
                   class="<?= str_starts_with($current, 'admin/categories') ? 'active' : '' ?>">
                    🧩 Kategorien
                </a>

                <a href="<?= $baseUrl ?>/index.php?url=admin/credits"
                   class="<?= str_starts_with($current, 'admin/credits') ? 'active' : '' ?>">
                    💰 Credits / Premium
                </a>
            </div>

            <div class="admin-nav-group">
                <div class="admin-nav-title">Verifizierungen</div>
                <a href="<?= $baseUrl ?>/index.php?url=admin/addressVerifications"
                   class="<?= str_starts_with($current, 'admin/addressVerifications') ? 'active' : '' ?>">
                    🏡 Adressen
                </a>

                <a href="<?= $baseUrl ?>/index.php?url=admin/idVerifications"
                   class="<?= str_starts_with($current, 'admin/idVerifications') ? 'active' : '' ?>">
                    🪪 ID-Bestätigungen
                </a>
            </div>

            <div class="admin-nav-group">
                <div class="admin-nav-title">System</div>
                <a href="<?= $baseUrl ?>/index.php?url=auth/logout">
                    🚪 Logout
                </a>
            </div>

        </nav>
    </aside>

    <main class="admin-main">

        <div class="admin-topbar">
            Eingeloggt als Admin · 
            <a href="<?= $baseUrl ?>">Zur Webseite</a>
        </div>
