<?php require __DIR__ . '/_admin_header.php'; ?>

<div class="admin-page-header">
    <div>
        <h1>Adress-Verifizierungen</h1>
        <div class="admin-breadcrumb">
            Verwaltung · Verifizierungen · Adressen
        </div>
    </div>
</div>

<div class="admin-card">
    <table class="admin-table">
        <thead>
        <tr>
            <th>ID</th>
            <th>User</th>
            <th>Adresse</th>
            <th>Status</th>
            <th>Token</th>
            <th>Eingereicht</th>
            <th>Aktionen</th>
        </tr>
        </thead>

        <tbody>
        <?php if (!empty($verifications)): ?>
            <?php foreach ($verifications as $v): ?>
                <tr>
                    <td>#<?= (int)$v['id'] ?></td>

                    <td>
                        <a href="<?= $baseUrl ?>/index.php?url=admin/user&id=<?= (int)$v['user_id'] ?>">
                            <?= htmlspecialchars($v['username'] ?? 'User '.$v['user_id']) ?>
                        </a>
                    </td>

                    <td><?= htmlspecialchars($v['address'] ?? '-') ?></td>

                    <td>
                        <?php if ($v['status'] === 'verified'): ?>
                            <span class="admin-tag verified">Verifiziert</span>
                        <?php elseif ($v['status'] === 'pending'): ?>
                            <span class="admin-tag pending">Offen</span>
                        <?php else: ?>
                            <span class="admin-tag"><?= htmlspecialchars($v['status']) ?></span>
                        <?php endif; ?>
                    </td>

                    <td style="font-size:12px;">
                        <?= htmlspecialchars($v['token'] ?: '-') ?>
                    </td>

                    <td><?= htmlspecialchars($v['created_at'] ?? '-') ?></td>

                    <td>
                        <?php if ($v['status'] !== 'verified'): ?>
                            <a href="<?= $baseUrl ?>/index.php?url=admin/addressAction&id=<?= (int)$v['id'] ?>&action=approve"
                               class="btn-small primary">
                                ✓ Verifizieren
                            </a>
                        <?php else: ?>
                            <span style="font-size:12px;color:#6b7280;">—</span>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>

        <?php else: ?>
            <tr>
                <td colspan="7" style="text-align:center; color:#9ca3af; padding:12px;">
                    Keine Adress-Verifizierungen vorhanden.
                </td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<?php require __DIR__ . '/_admin_footer.php'; ?>
