<?php require __DIR__ . '/_admin_header.php'; ?>

<h1>Kategorien</h1>
<div class="admin-breadcrumb">Struktur · Verwaltung · Import</div>

<div class="admin-card" style="margin-bottom:16px;">
    <div style="display:flex;justify-content:space-between;align-items:center;">
        <div>
            <div style="font-size:14px;font-weight:600;">Kategoriestruktur</div>
            <div style="font-size:12px;color:#6b7280;">
                Übersicht über alle Haupt- und Unterkategorien
            </div>
        </div>

        <div style="display:flex;gap:8px;">
            <a class="btn-small primary"
               href="<?= $baseUrl ?>/index.php?url=admin/category_add">
                + Neue Kategorie
            </a>

            <a class="btn-small"
               href="<?= $baseUrl ?>/index.php?url=admin/category_import">
                JSON Import →
            </a>
        </div>
    </div>
</div>

<div class="admin-card">
    <table class="admin-table">
        <thead>
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Slug</th>
            <th>Reihenfolge</th>
            <th>Aktiv</th>
            <th></th>
        </tr>
        </thead>
        <tbody>

        <?php if (!empty($categories)): ?>
            <?php foreach ($categories as $cat): ?>
                <tr style="<?= $cat['parent_id'] ? 'background:#f9fafb;' : '' ?>">
                    <td><?= (int)$cat['id'] ?></td>

                    <td>
                        <?php if (!$cat['parent_id']): ?>
                            <strong>📦 <?= htmlspecialchars($cat['name']) ?></strong>
                        <?php else: ?>
                            <span style="padding-left:22px;">↳ <?= htmlspecialchars($cat['name']) ?></span>
                        <?php endif; ?>
                    </td>

                    <td><?= htmlspecialchars($cat['slug']) ?></td>
                    <td><?= (int)$cat['sort_order'] ?></td>

                    <td>
                        <?php if ((int)$cat['is_active'] === 1): ?>
                            <span class="admin-tag verified">Ja</span>
                        <?php else: ?>
                            <span class="admin-tag pending">Nein</span>
                        <?php endif; ?>
                    </td>

                    <td>
                        <a class="btn-small"
                           href="<?= $baseUrl ?>/index.php?url=admin/category_edit&id=<?= (int)$cat['id'] ?>">
                            Bearbeiten
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="6" style="text-align:center;color:#9ca3af;">
                    Keine Kategorien angelegt.
                </td>
            </tr>
        <?php endif; ?>

        </tbody>
    </table>
</div>

<?php require __DIR__ . '/_admin_footer.php'; ?>
