<?php require __DIR__ . '/_admin_header.php'; ?>

<h1>Kategorie bearbeiten</h1>
<div class="admin-breadcrumb">Kategorien · Bearbeiten</div>

<div class="admin-card" style="max-width:600px; margin-bottom:20px;">

    <form method="POST"
          action="<?= $baseUrl ?>/index.php?url=admin/category_update&id=<?= (int)$category['id'] ?>">

        <div class="form-group" style="margin-bottom:12px;">
            <label>Name *</label>
            <input type="text" name="name" required
                   value="<?= htmlspecialchars($category['name']) ?>"
                   style="width:100%; padding:8px 10px; border-radius:8px; border:1px solid #d1d5db;">
        </div>

        <div class="form-group" style="margin-bottom:12px;">
            <label>Slug *</label>
            <input type="text" name="slug" required
                   value="<?= htmlspecialchars($category['slug']) ?>"
                   style="width:100%; padding:8px 10px; border-radius:8px; border:1px solid #d1d5db;">
        </div>

        <div class="form-group" style="margin-bottom:12px;">
            <label>Übergeordnete Kategorie</label>
            <select name="parent_id"
                    style="width:100%; padding:8px 10px; border-radius:8px; border:1px solid #d1d5db;">
                <option value="">(keine – Hauptkategorie)</option>

                <?php foreach ($allCategories as $c): ?>
                    <?php if ($c['id'] != $category['id']): ?>
                        <option value="<?= $c['id'] ?>"
                                <?= $category['parent_id'] == $c['id'] ? 'selected' : '' ?>>
                            <?= htmlspecialchars($c['name']) ?>
                        </option>
                    <?php endif; ?>
                <?php endforeach; ?>
            </select>
        </div>

        <div class="form-group" style="margin-bottom:12px;">
            <label>Sortierreihenfolge</label>
            <input type="number" name="sort_order"
                   value="<?= (int)$category['sort_order'] ?>"
                   style="width:100%; padding:8px 10px; border-radius:8px; border:1px solid #d1d5db;">
        </div>

        <div class="form-group" style="margin-bottom:16px;">
            <label>Status</label>
            <select name="is_active"
                    style="width:100%; padding:8px 10px; border-radius:8px; border:1px solid #d1d5db;">
                <option value="1" <?= $category['is_active'] ? 'selected' : '' ?>>Aktiv</option>
                <option value="0" <?= !$category['is_active'] ? 'selected' : '' ?>>Inaktiv</option>
            </select>
        </div>

        <div style="display:flex; gap:10px;">
            <button class="btn-small primary" type="submit">Speichern</button>
            <a href="<?= $baseUrl ?>/index.php?url=admin/categories" class="btn-small">Abbrechen</a>
        </div>

    </form>

</div>

<?php require __DIR__ . '/_admin_footer.php'; ?>
