<?php require __DIR__ . '/_admin_header.php'; ?>

<div class="admin-page-header">
    <div>
        <h1>Credits & Preise</h1>
        <div class="admin-breadcrumb">
            Verwaltung · Credits · Pakete & Einstellungen
        </div>
    </div>
</div>

<!-- ===========================
     CREDIT PAKETE
     =========================== -->
<div class="admin-card" style="margin-bottom:20px;">
    <h2 style="margin:0 0 10px;font-size:17px;font-weight:600;">
        Credit-Pakete
    </h2>

    <table class="admin-table">
        <thead>
        <tr>
            <th>ID</th>
            <th>Credits</th>
            <th>Preis (CHF)</th>
            <th>Sort</th>
            <th>Aktion</th>
        </tr>
        </thead>

        <tbody>
        <?php if (!empty($creditPacks)): ?>
            <?php foreach ($creditPacks as $p): ?>
                <tr>
                    <td>#<?= (int)$p['id'] ?></td>
                    <td><?= (int)$p['credits'] ?> Credits</td>
                    <td><?= number_format((float)$p['price_chf'], 2, ',', '\'') ?> CHF</td>
                    <td><?= (int)$p['sort_order'] ?></td>
                    <td>
                        <a href="<?= $baseUrl ?>/index.php?url=admin/credits&editPack=<?= (int)$p['id'] ?>"
                           class="btn-small">Bearbeiten</a>

                        <a href="<?= $baseUrl ?>/index.php?url=admin/credits&deletePack=<?= (int)$p['id'] ?>"
                           class="btn-small danger"
                           onclick="return confirm('Dieses Paket wirklich löschen?');">
                            Löschen
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>

        <?php else: ?>
            <tr>
                <td colspan="5" style="text-align:center;color:#9ca3af;">
                    Noch keine Credit-Pakete vorhanden.
                </td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- ===========================
     CREDIT PAKET HINZUFÜGEN
     =========================== -->
<div class="admin-card" style="margin-bottom:30px;">

    <?php if (!empty($editPack)): ?>
        <h2 style="margin:0 0 10px;font-size:17px;font-weight:600;">
            Paket bearbeiten
        </h2>
    <?php else: ?>
        <h2 style="margin:0 0 10px;font-size:17px;font-weight:600;">
            Neues Credit-Paket hinzufügen
        </h2>
    <?php endif; ?>

    <form method="POST" action="<?= $baseUrl ?>/index.php?url=admin/credits">
        <input type="hidden" name="action" value="savePack">
        <input type="hidden" name="id" value="<?= $editPack['id'] ?? '' ?>">

        <div style="display:flex; gap:14px; margin-bottom:10px;">
            <div style="flex:1;">
                <label>Credits</label>
                <input type="number" name="credits" required min="1"
                       value="<?= $editPack['credits'] ?? '' ?>"
                       style="width:100%;padding:8px;border-radius:8px;border:1px solid #d1d5db;">
            </div>

            <div style="flex:1;">
                <label>Preis (CHF)</label>
                <input type="number" step="0.01" name="price_chf" required min="0"
                       value="<?= $editPack['price_chf'] ?? '' ?>"
                       style="width:100%;padding:8px;border-radius:8px;border:1px solid #d1d5db;">
            </div>

            <div style="width:120px;">
                <label>Sortierung</label>
                <input type="number" name="sort_order" required min="0"
                       value="<?= $editPack['sort_order'] ?? '0' ?>"
                       style="width:100%;padding:8px;border-radius:8px;border:1px solid #d1d5db;">
            </div>
        </div>

        <button class="btn-small primary" style="margin-top:6px;">
            Speichern
        </button>
    </form>
</div>

<!-- ===========================
     PREMIUM PLÄNE
     =========================== -->
<div class="admin-card" style="margin-bottom:20px;">
    <h2 style="margin:0 0 10px;font-size:17px;font-weight:600;">
        Premium / Platin Abos
    </h2>

    <table class="admin-table">
        <thead>
        <tr>
            <th>ID</th>
            <th>Name</th>
            <th>Preis (CHF)</th>
            <th>Sort</th>
            <th>Aktion</th>
        </tr>
        </thead>

        <tbody>
        <?php if (!empty($premiumPlans)): ?>
            <?php foreach ($premiumPlans as $plan): ?>
                <tr>
                    <td>#<?= (int)$plan['id'] ?></td>
                    <td><?= htmlspecialchars($plan['name']) ?></td>
                    <td><?= number_format((float)$plan['price_chf'], 2, ',', '\'') ?> CHF / Monat</td>
                    <td><?= (int)$plan['sort_order'] ?></td>
                    <td>
                        <a href="<?= $baseUrl ?>/index.php?url=admin/credits&editPlan=<?= (int)$plan['id'] ?>"
                           class="btn-small">Bearbeiten</a>

                        <a href="<?= $baseUrl ?>/index.php?url=admin/credits&deletePlan=<?= (int)$plan['id'] ?>"
                           class="btn-small danger"
                           onclick="return confirm('Diesen Plan wirklich löschen?');">
                            Löschen
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>

        <?php else: ?>
            <tr>
                <td colspan="5" style="text-align:center;color:#9ca3af;">
                    Keine Premium-Pläne vorhanden.
                </td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<!-- ===========================
     PREMIUM PLAN HINZUFÜGEN
     =========================== -->
<div class="admin-card">

    <?php if (!empty($editPlan)): ?>
        <h2 style="margin:0 0 10px;font-size:17px;font-weight:600;">
            Premium-Plan bearbeiten
        </h2>
    <?php else: ?>
        <h2 style="margin:0 0 10px;font-size:17px;font-weight:600;">
            Neuen Premium-Plan hinzufügen
        </h2>
    <?php endif; ?>

    <form method="POST" action="<?= $baseUrl ?>/index.php?url=admin/credits">
        <input type="hidden" name="action" value="savePlan">
        <input type="hidden" name="id" value="<?= $editPlan['id'] ?? '' ?>">

        <div style="display:flex; gap:14px; margin-bottom:10px;">
            <div style="flex:1;">
                <label>Name</label>
                <input type="text" name="name" required
                       value="<?= $editPlan['name'] ?? '' ?>"
                       style="width:100%;padding:8px;border-radius:8px;border:1px solid #d1d5db;">
            </div>

            <div style="flex:1;">
                <label>Preis (CHF / Monat)</label>
                <input type="number" step="0.01" name="price_chf" required min="0"
                       value="<?= $editPlan['price_chf'] ?? '' ?>"
                       style="width:100%;padding:8px;border-radius:8px;border:1px solid #d1d5db;">
            </div>

            <div style="width:120px;">
                <label>Sortierung</label>
                <input type="number" name="sort_order" required min="0"
                       value="<?= $editPlan['sort_order'] ?? '0' ?>"
                       style="width:100%;padding:8px;border-radius:8px;border:1px solid #d1d5db;">
            </div>

        </div>

        <button class="btn-small primary" style="margin-top:6px;">
            Speichern
        </button>
    </form>
</div>

<?php require __DIR__ . '/_admin_footer.php'; ?>
