<?php require __DIR__ . '/_admin_header.php'; ?>

<style>
:root {
    --admin-bg: #0d1117;
    --admin-card: #161b22;
    --admin-border: #30363d;
    --admin-text: #e6edf3;
    --admin-muted: #8b949e;
    --admin-accent: #facc15;
    --admin-blue: #0ea5e9;
    --admin-green: #22c55e;
    --admin-red: #ef4444;
    --admin-radius: 14px;
    --admin-shadow: 0 8px 24px rgba(0,0,0,0.35);
}

body {
    background: var(--admin-bg);
}

.admin-stat-card {
    background: var(--admin-card);
    border: 1px solid var(--admin-border);
    border-radius: var(--admin-radius);
    padding: 18px;
    box-shadow: var(--admin-shadow);
    position: relative;
    overflow: hidden;
}

.admin-stat-card .admin-stat-label {
    font-size: 12px;
    color: var(--admin-muted);
    text-transform: uppercase;
    letter-spacing: .07em;
}

.admin-stat-card .admin-stat-value {
    font-size: 32px;
    font-weight: 700;
    margin-top: 6px;
    color: var(--admin-accent);
}

.admin-stat-card .admin-stat-sub {
    font-size: 12px;
    margin-top: 6px;
    color: var(--admin-muted);
}

/* Neue Grid */
.admin-dashboard-grid {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(260px, 1fr));
    gap: 20px;
}

/* Glow effect */
.admin-stat-card::after {
    content: "";
    position: absolute;
    width: 140px;
    height: 140px;
    top: -40px;
    right: -40px;
    background: radial-gradient(circle at center, rgba(250,204,21,0.25), transparent 60%);
    pointer-events: none;
}
table.admin-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 13px;
    background: var(--admin-card);
}

.admin-table th {
    background: #1f242d;
    border-bottom: 1px solid var(--admin-border);
    padding: 8px;
    color: var(--admin-muted);
}

.admin-table td {
    padding: 8px;
    border-bottom: 1px solid var(--admin-border);
    color: var(--admin-text);
}

.admin-table tr:hover td {
    background: rgba(255,255,255,0.02);
}
table.admin-table {
    width: 100%;
    border-collapse: collapse;
    font-size: 13px;
    background: var(--admin-card);
}

.admin-table th {
    background: #1f242d;
    border-bottom: 1px solid var(--admin-border);
    padding: 8px;
    color: var(--admin-muted);
}

.admin-table td {
    padding: 8px;
    border-bottom: 1px solid var(--admin-border);
    color: var(--admin-text);
}

.admin-table tr:hover td {
    background: rgba(255,255,255,0.02);
}

</style>



<div class="admin-page-header">
    <div>
        <h1>Admin-Dashboard</h1>
        <div class="admin-breadcrumb">
            Übersicht · System · Monitoring
        </div>
    </div>
    <?php if (!empty($admin)): ?>
        <div>
            <div style="font-size:13px;color:#9ca3af;">
                Eingeloggt als
            </div>
            <div style="font-size:14px;font-weight:600;">
                <?= htmlspecialchars($admin['email']) ?>
                <span style="font-size:12px;color:#6b7280;">
                    (<?= htmlspecialchars($admin['role'] ?? 'admin') ?>)
                </span>
            </div>
        </div>
    <?php endif; ?>
</div>

<!-- TOP STATS -->
<div class="admin-dashboard-grid">

    <!-- USERS -->
    <div class="admin-stat-card">
        <div class="admin-stat-label">Nutzer gesamt</div>
        <div class="admin-stat-value"><?= (int)$totalUsers ?></div>
        <div class="admin-stat-sub">
            Aktiv: <?= (int)$activeUsers ?> · Gesperrt: <?= (int)$bannedUsers ?>
        </div>
    </div>

    <!-- NEW USERS -->
    <div class="admin-stat-card">
        <div class="admin-stat-label">Neue Nutzer (7 Tage)</div>
        <div class="admin-stat-value"><?= (int)$newUsers7 ?></div>
        <div class="admin-stat-sub">
            Wachstum im Wochenvergleich
        </div>
    </div>

    <!-- ADS -->
    <div class="admin-stat-card">
        <div class="admin-stat-label">Inserate gesamt</div>
        <div class="admin-stat-value"><?= (int)$totalAds ?></div>
        <div class="admin-stat-sub">
            Aktive Anzeigen im Marktplatz
        </div>
    </div>

    <!-- PREMIUM -->
    <div class="admin-stat-card">
        <div class="admin-stat-label">Premium & Credits</div>
        <div class="admin-stat-value"><?= (int)$activeSubscriptions ?></div>
        <div class="admin-stat-sub">
            Credits ausgegeben: <?= (int)$creditsSpent ?>
        </div>
    </div>

</div>

    </div>
</div>

<!-- VERIFICATIONS + QUICK OVERVIEW -->
<div class="admin-flex-2">
    <div class="admin-card">
        <div class="admin-section-title">Verifizierungen</div>
        <div class="admin-section-sub">
            Offene Prüfungen für ID & Adresse.
        </div>

        <div style="display:flex; gap:10px; flex-wrap:wrap; margin-bottom:8px;">
            <span class="admin-chip pill-amber">
                🪪 Offene ID-Prüfungen: <strong><?= (int)$pendingId ?></strong>
            </span>

            <span class="admin-chip pill-sky">
                🏠 Offene Adress-Prüfungen: <strong><?= (int)$pendingAddress ?></strong>
            </span>
        </div>

        <div style="font-size:12px;color:#6b7280;margin-top:6px;">
            <a href="<?= $baseUrl ?>/index.php?url=admin/idVerifications">ID-Verifizierungen öffnen</a> ·
            <a href="<?= $baseUrl ?>/index.php?url=admin/addressVerifications">Adress-Verifizierungen öffnen</a>
        </div>
    </div>

    <div class="admin-card">
        <div class="admin-section-title">Tarife · Credits & Premium</div>
        <div class="admin-section-sub">
            Übersicht über Konfiguration der Pakete.
        </div>

        <div class="admin-two-cols">
            <div>
                <div style="font-size:12px;font-weight:600;margin-bottom:4px;">Credit-Pakete</div>
                <?php if (!empty($creditPacks)): ?>
                    <ul style="list-style:none;padding:0;margin:0;font-size:12px;">
                        <?php foreach ($creditPacks as $pack): ?>
                            <li style="margin-bottom:3px;">
                                <?= (int)$pack['credits'] ?> Credits
                                · <?= number_format((float)$pack['price_chf'], 2, ',', '\'') ?> CHF
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <div style="font-size:12px;color:#9ca3af;">Noch keine Credit-Pakete angelegt.</div>
                <?php endif; ?>
            </div>

            <div>
                <div style="font-size:12px;font-weight:600;margin-bottom:4px;">Premium / Platin</div>
                <?php if (!empty($premiumPlans)): ?>
                    <ul style="list-style:none;padding:0;margin:0;font-size:12px;">
                        <?php foreach ($premiumPlans as $plan): ?>
                            <li style="margin-bottom:3px;">
                                <?= htmlspecialchars($plan['name']) ?>:
                                <?= number_format((float)$plan['price_chf'], 2, ',', '\'') ?> CHF / Monat
                            </li>
                        <?php endforeach; ?>
                    </ul>
                <?php else: ?>
                    <div style="font-size:12px;color:#9ca3af;">Noch keine Premium-Pläne konfiguriert.</div>
                <?php endif; ?>
            </div>
        </div>

        <div style="margin-top:8px;font-size:12px;">
            <a href="<?= $baseUrl ?>/index.php?url=admin/credits">
                Preise / Pakete bearbeiten →
            </a>
        </div>
    </div>
</div>

<!-- LETZTE NUTZER & INSERATE -->
<div class="admin-two-cols">
    <div class="admin-card">
        <div class="admin-section-title">Letzte registrierte Nutzer</div>
        <div class="admin-section-sub">
            Neueste Accounts, sortiert nach Registrierdatum.
        </div>

        <table class="admin-table">
            <thead>
            <tr>
                <th>ID</th>
                <th>Username</th>
                <th>E-Mail</th>
                <th>Status</th>
                <th>Registriert</th>
                <th></th>
            </tr>
            </thead>
            <tbody>
            <?php if (!empty($recentUsers)): ?>
                <?php foreach ($recentUsers as $u): ?>
                    <tr>
                        <td><?= (int)$u['id'] ?></td>
                        <td><?= htmlspecialchars($u['username'] ?? '–') ?></td>
                        <td><?= htmlspecialchars($u['email'] ?? '–') ?></td>
                        <td>
                            <?php
                            $status = $u['status'] ?? 'active';
                            if ($status === 'banned'): ?>
                                <span class="admin-tag rejected">Gesperrt</span>
                            <?php else: ?>
                                <span class="admin-tag verified">Aktiv</span>
                            <?php endif; ?>
                        </td>
                        <td><?= htmlspecialchars($u['created_at'] ?? '–') ?></td>
                        <td>
                            <a class="btn-small"
                               href="<?= $baseUrl ?>/index.php?url=admin/user&id=<?= (int)$u['id'] ?>">
                                Details
                            </a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="6" style="text-align:center;font-size:12px;color:#9ca3af;">
                        Keine Nutzer vorhanden.
                    </td>
                </tr>
            <?php endif; ?>
            </tbody>
        </table>
    </div>

    <div class="admin-card">
        <div class="admin-section-title">Neueste Inserate</div>
        <div class="admin-section-sub">
            Schnellzugriff auf aktuell eingestellte Anzeigen.
        </div>

        <table class="admin-table">
            <thead>
            <tr>
                <th>ID</th>
                <th>User</th>
                <th>Erstellt</th>
            </tr>
            </thead>
            <tbody>
            <?php if (!empty($recentAds)): ?>
                <?php foreach ($recentAds as $ad): ?>
                    <tr>
                        <td>#<?= (int)$ad['id'] ?></td>
                        <td>
                            <?= htmlspecialchars($ad['username'] ?? ('User #' . (int)$ad['user_id'])) ?>
                        </td>
                        <td><?= htmlspecialchars($ad['created_at'] ?? '–') ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="3" style="text-align:center;font-size:12px;color:#9ca3af;">
                        Noch keine Inserate vorhanden.
                    </td>
                </tr>
            <?php endif; ?>
            </tbody>
        </table>

        <div style="margin-top:8px;font-size:12px;">
            (Optional kannst du hier später einen "Zur Inseratverwaltung"-Link einbauen.)
        </div>
    </div>
</div>

<?php require __DIR__ . '/_admin_footer.php'; ?>
