<?php require __DIR__ . '/_admin_header.php'; ?>

<div class="admin-page-header">
    <div>
        <h1>ID-Verifizierungen</h1>
        <div class="admin-breadcrumb">
            Verwaltung · Verifizierungen · Identität
        </div>
    </div>
</div>

<div class="admin-card">
    <table class="admin-table">
        <thead>
        <tr>
            <th>ID</th>
            <th>User</th>
            <th>Front</th>
            <th>Back</th>
            <th>Status</th>
            <th>Eingereicht</th>
            <th>Aktionen</th>
        </tr>
        </thead>

        <tbody>
        <?php if (!empty($verifications)): ?>
            <?php foreach ($verifications as $v): ?>
                <tr>
                    <td>#<?= (int)$v['id'] ?></td>

                    <td>
                        <a href="<?= $baseUrl ?>/index.php?url=admin/user&id=<?= (int)$v['user_id'] ?>">
                            <?= htmlspecialchars($v['username'] ?? 'User '.$v['user_id']) ?>
                        </a>
                    </td>

                    <!-- Front image -->
                    <td>
                        <?php if (!empty($v['front_path'])): ?>
                            <a href="<?= $baseUrl ?>/<?= htmlspecialchars($v['front_path']) ?>" 
                               target="_blank"
                               class="btn-small">
                                📄 Öffnen
                            </a>
                        <?php else: ?> – <?php endif; ?>
                    </td>

                    <!-- Back image -->
                    <td>
                        <?php if (!empty($v['back_path'])): ?>
                            <a href="<?= $baseUrl ?>/<?= htmlspecialchars($v['back_path']) ?>" 
                               target="_blank"
                               class="btn-small">
                                📄 Öffnen
                            </a>
                        <?php else: ?> – <?php endif; ?>
                    </td>

                    <!-- Status -->
                    <td>
                        <?php if ($v['status'] === 'approved'): ?>
                            <span class="admin-tag verified">Verifiziert</span>
                        <?php elseif ($v['status'] === 'pending'): ?>
                            <span class="admin-tag pending">Offen</span>
                        <?php else: ?>
                            <span class="admin-tag"><?= htmlspecialchars($v['status']) ?></span>
                        <?php endif; ?>
                    </td>

                    <td><?= htmlspecialchars($v['created_at'] ?? '-') ?></td>

                    <td style="white-space:nowrap;">
                        <?php if ($v['status'] !== 'approved'): ?>
                            <a href="<?= $baseUrl ?>/index.php?url=admin/idAction&id=<?= (int)$v['id'] ?>&action=approve"
                               class="btn-small primary">
                                ✓ Freigeben
                            </a>
                        <?php else: ?>
                            <span style="color:#6b7280;font-size:12px;">—</span>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>

        <?php else: ?>
            <tr>
                <td colspan="7" style="text-align:center; color:#9ca3af; padding:12px;">
                    Keine ID-Verifizierungen vorhanden.
                </td>
            </tr>
        <?php endif; ?>
        </tbody>

    </table>
</div>

<?php require __DIR__ . '/_admin_footer.php'; ?>
