<?php
$baseUrl = $config['app']['base_url'];
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Admin Login</title>

    <style>
        body {
            background: #f3f4f6;
            font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }

        .login-box {
            background: #ffffff;
            padding: 32px;
            width: 340px;
            border-radius: 14px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.08);
        }

        .login-title {
            font-size: 22px;
            font-weight: 700;
            margin-bottom: 20px;
            text-align: center;
            color: #111827;
        }

        label {
            font-size: 13px;
            font-weight: 600;
            color: #374151;
        }

        input {
            width: 100%;
            padding: 10px 12px;
            margin-top: 4px;
            margin-bottom: 12px;
            border: 1px solid #d1d5db;
            border-radius: 8px;
            font-size: 14px;
        }

        input:focus {
            border-color: #0ea5e9;
            outline: none;
            box-shadow: 0 0 0 3px rgba(14,165,233,0.2);
        }

        .btn {
            width: 100%;
            padding: 10px 12px;
            font-size: 15px;
            font-weight: 600;
            border-radius: 8px;
            background: #0ea5e9;
            color: white;
            border: none;
            cursor: pointer;
        }

        .btn:hover {
            background: #0284c7;
        }

        .error-box {
            background: #fee2e2;
            padding: 10px 12px;
            border-radius: 8px;
            color: #991b1b;
            font-size: 13px;
            margin-bottom: 16px;
        }

    </style>
</head>
<body>

<div class="login-box">
    <div class="login-title">Admin Login</div>

    <?php if (!empty($error)): ?>
        <div class="error-box"><?= htmlspecialchars($error) ?></div>
    <?php endif; ?>

    <form action="<?= $baseUrl ?>/index.php?url=admin/auth" method="post">

       <label>E-Mail:</label><br>
<input type="email" name="email" autocomplete="email" required>

<label>Passwort:</label><br>
<input type="password" name="password" autocomplete="current-password" required>


        <button type="submit" class="btn">Login</button>
    </form>
</div>

</body>
</html>
