<?php
$config  = require __DIR__ . '/../../config/config.php';
$baseUrl = $config['app']['base_url'];

$packs       = $packs ?? [];
$premiumPlan = $premiumPlan ?? null;
?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Admin – Preise & Pakete</title>
    <style>
        body { font-family: system-ui, -apple-system, BlinkMacSystemFont, "Segoe UI", sans-serif; font-size:14px; }
        .wrap { max-width: 1000px; margin: 20px auto 40px; padding: 0 12px; }
        h1 { font-size: 22px; margin-bottom: 4px; }
        .sub { font-size:12px;color:#6b7280;margin-bottom:18px; }

        .card {
            background:#ffffff;
            border-radius:12px;
            border:1px solid #e5e7eb;
            padding:14px 16px;
            margin-bottom:16px;
        }
        table { width:100%; border-collapse:collapse; font-size:13px; }
        th, td { padding:6px 4px; border-bottom:1px solid #e5e7eb; }
        th { text-align:left; font-size:11px; color:#6b7280; }

        .btn {
            border-radius:999px;
            padding:7px 13px;
            font-size:13px;
            border:none;
            cursor:pointer;
            background:#0f766e;
            color:#fff;
        }
        .btn:hover { opacity:0.9; }

        input[type="text"], input[type="number"] {
            width:100%;
            box-sizing:border-box;
            padding:4px 6px;
            font-size:13px;
        }
        input[type="checkbox"] {
            transform:scale(1.1);
        }
        .small-note { font-size:11px;color:#6b7280;margin-top:4px; }
        a { color:#0f766e; text-decoration:none; font-size:12px; }
        a:hover { text-decoration:underline; }
    </style>
</head>
<body>
<div class="wrap">
    <h1>Preise & Pakete</h1>
    <div class="sub">
        Hier stellst du die Credit-Pakete und den Preis für das Platin-Abo ein.
    </div>

    <form method="post" action="<?= $baseUrl ?>/index.php?url=admin/pricing/save">

        <section class="card">
            <h2 style="font-size:16px;margin:0 0 8px;">Credit-Pakete</h2>
            <table>
                <thead>
                    <tr>
                        <th>Code</th>
                        <th>Name</th>
                        <th>Credits</th>
                        <th>Preis (CHF)</th>
                        <th>Reihenfolge</th>
                        <th>Aktiv</th>
                    </tr>
                </thead>
                <tbody>
                <?php foreach ($packs as $p): ?>
                    <tr>
                        <td>
                            <input type="text" name="packs[<?= (int)$p['id'] ?>][code]"
                                   value="<?= htmlspecialchars($p['code']) ?>">
                        </td>
                        <td>
                            <input type="text" name="packs[<?= (int)$p['id'] ?>][name]"
                                   value="<?= htmlspecialchars($p['name']) ?>">
                        </td>
                        <td>
                            <input type="number" name="packs[<?= (int)$p['id'] ?>][credits]"
                                   value="<?= (int)$p['credits'] ?>">
                        </td>
                        <td>
                            <input type="text" name="packs[<?= (int)$p['id'] ?>][price_chf]"
                                   value="<?= htmlspecialchars($p['price_chf']) ?>">
                        </td>
                        <td>
                            <input type="number" name="packs[<?= (int)$p['id'] ?>][sort_order]"
                                   value="<?= (int)$p['sort_order'] ?>">
                        </td>
                        <td style="text-align:center;">
                            <input type="checkbox" name="packs[<?= (int)$p['id'] ?>][is_active]"
                                   <?= !empty($p['is_active']) ? 'checked' : '' ?>>
                        </td>
                    </tr>
                <?php endforeach; ?>
                </tbody>
            </table>
            <div class="small-note">
                Neue Pakete könntest du später über einen separaten „Neu“-Button hinzufügen – aktuell bearbeiten wir nur bestehende.
            </div>
        </section>

        <section class="card">
            <h2 style="font-size:16px;margin:0 0 8px;">Platin-Abo (Premium Chat)</h2>
            <?php
                $premiumPrice = $premiumPlan ? $premiumPlan['price_chf'] : 9.95;
                $premiumDays  = $premiumPlan ? (int)$premiumPlan['duration_days'] : 30;
            ?>
            <div style="display:flex;gap:12px;align-items:flex-end;flex-wrap:wrap;">
                <div>
                    <label style="font-size:12px;color:#6b7280;">Preis (CHF / Monat)</label><br>
                    <input type="text" name="premium_price" value="<?= htmlspecialchars($premiumPrice) ?>" style="width:120px;">
                </div>
                <div>
                    <label style="font-size:12px;color:#6b7280;">Dauer in Tagen</label><br>
                    <input type="number" name="premium_days" value="<?= $premiumDays ?>" style="width:80px;">
                </div>
            </div>
            <div class="small-note">
                Diese Werte nutzt das System für das Platin-Abo (Premium Chat).<br>
                Die Buttons im Dashboard und im Checkout lesen direkt diese Preise.
            </div>
        </section>

        <button class="btn" type="submit">Änderungen speichern</button>
    </form>

    <div style="margin-top:10px;">
        <a href="<?= $baseUrl ?>/index.php?url=admin/dashboard">← Zurück zum Admin-Dashboard</a>
    </div>
</div>
</body>
</html>
