<?php require __DIR__ . '/_admin_header.php'; ?>

<h1>Inserate von User #<?= (int)$userId ?></h1>
<div class="admin-breadcrumb">Benutzer · Inserate</div>

<div class="admin-card">

<?php if (empty($ads)): ?>
    <p>Keine Inserate vorhanden.</p>
<?php else: ?>
    <table class="admin-table">
        <thead>
            <tr>
                <th>ID</th>
                <th>Titel</th>
                <th>Bild</th>
                <th>Erstellt</th>
                <th>Öffnen</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($ads as $ad): ?>
            <tr>
                <td><?= (int)$ad['id'] ?></td>
                <td><?= htmlspecialchars($ad['title']) ?></td>
                <td>
                    <?php if (!empty($ad['image'])): ?>
                        <img src="/uploads/ad/<?= htmlspecialchars($ad['image']) ?>" style="height:50px;">
                    <?php endif; ?>
                </td>
                <td><?= htmlspecialchars($ad['created_at']) ?></td>
                <td>
                    <a target="_blank" href="<?= $baseUrl ?>/index.php?url=ad/view&id=<?= (int)$ad['id'] ?>">
                        Anzeigen
                    </a>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
<?php endif; ?>

</div>

<?php require __DIR__ . '/_admin_footer.php'; ?>
