<?php require __DIR__ . '/_admin_header.php'; ?>

<h1>Benutzer #<?= (int)$user['id'] ?></h1>
<div class="admin-breadcrumb">
    Details · Verwaltung · Aktionen
</div>

<div class="admin-card" style="margin-bottom:16px;">
    <div style="display:flex;justify-content:space-between;align-items:flex-start;">
        <div>
            <h2 style="margin:0;font-size:18px;">
                <?= htmlspecialchars($user['username']) ?>
            </h2>
            <div style="font-size:13px;color:#6b7280;">
                <?= htmlspecialchars($user['email']) ?>
            </div>

            <div style="margin-top:8px;">
                <?php if ($user['status'] === 'banned'): ?>
                    <span class="admin-tag rejected">Gesperrt</span>
                <?php else: ?>
                    <span class="admin-tag verified">Aktiv</span>
                <?php endif; ?>

                <span class="admin-tag pending">
                    Trust: <?= (int)$user['trust'] ?>%
                </span>
            </div>
        </div>

        <div>
            <?php if ($user['status'] === 'banned'): ?>
                <a class="btn-small primary"
                   href="<?= $baseUrl ?>/index.php?url=admin/userUnban&id=<?= (int)$user['id'] ?>">
                    Entsperren
                </a>
            <?php else: ?>
                <a class="btn-small danger"
                   href="<?= $baseUrl ?>/index.php?url=admin/userBan&id=<?= (int)$user['id'] ?>">
                    Benutzer sperren
                </a>
            <?php endif; ?>
        </div>
    </div>
</div>

<div class="admin-two-cols">
    <div class="admin-card">
        <h3 style="margin-top:0;font-size:16px;">Kontakt / Profil</h3>

        <table class="admin-table">
            <tr><th>E-Mail</th><td><?= htmlspecialchars($user['email']) ?></td></tr>
            <tr><th>Telefon</th><td><?= htmlspecialchars($user['phone'] ?: '–') ?></td></tr>
            <tr><th>Adresse</th><td><?= htmlspecialchars($user['address'] ?: '–') ?></td></tr>
            <tr><th>Registriert</th><td><?= htmlspecialchars($user['created_at']) ?></td></tr>
        </table>
    </div>

    <div class="admin-card">
        <h3 style="margin-top:0;font-size:16px;">Verifizierungen</h3>

        <table class="admin-table">
            <tr><th>E-Mail</th><td><?= $ver['email_verified'] ? '✔️ verifiziert' : '❌' ?></td></tr>
            <tr><th>Telefon</th><td><?= $ver['phone_verified'] ? '✔️ verifiziert' : '❌' ?></td></tr>
            <tr><th>Adresse</th><td><?= $ver['address_verified'] ? '✔️ verifiziert' : '❌' ?></td></tr>
            <tr><th>Ausweis</th><td><?= $ver['id_verified'] ? '✔️ verifiziert' : '❌' ?></td></tr>
        </table>

        <div style="margin-top:10px;">
            <a class="btn-small primary"
               href="<?= $baseUrl ?>/index.php?url=admin/idVerifications">
                ID-Prüfungen öffnen →
            </a>
        </div>
    </div>
</div>

<?php require __DIR__ . '/_admin_footer.php'; ?>
