<?php require __DIR__ . '/_admin_header.php'; ?>

<h1>Benutzerverwaltung</h1>
<div class="admin-breadcrumb">Alle registrierten Nutzer</div>

<div class="admin-card">
    <table class="admin-table">
        <thead>
        <tr>
            <th>ID</th>
            <th>Username</th>
            <th>E-Mail</th>
            <th>Status</th>
            <th>Registriert</th>
            <th></th>
        </tr>
        </thead>

        <tbody>
        <?php if (!empty($users)): ?>
            <?php foreach ($users as $u): ?>
                <tr>
                    <td><?= (int)$u['id'] ?></td>
                    <td><?= htmlspecialchars($u['username']) ?></td>
                    <td><?= htmlspecialchars($u['email']) ?></td>
                    <td>
                        <?php if ($u['status'] === 'banned'): ?>
                            <span class="admin-tag rejected">Gesperrt</span>
                        <?php else: ?>
                            <span class="admin-tag verified">Aktiv</span>
                        <?php endif; ?>
                    </td>
                    <td><?= htmlspecialchars($u['created_at']) ?></td>
                    <td>
                        <a class="btn-small primary"
                           href="<?= $baseUrl ?>/index.php?url=admin/user&id=<?= (int)$u['id'] ?>">
                            Details →
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="6" style="text-align:center;color:#9ca3af;">
                    Keine Nutzer gefunden.
                </td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div>

<?php require __DIR__ . '/_admin_footer.php'; ?>
